
################################################################
# Pretty please don't look at me until after recitation :D
################################################################


################################
# Knapsack Memoization Review
################################

def knapsack_indexed_memoized(items, capacity):
    memo = {}
    return kim_helper(items, 0, capacity, memo)


def kim_helper(items, index, capacity, memo):
    # bypass if already in memo
    if (index, capacity) in memo:
        return memo[index, capacity]

    # base case: no more items, empty solution
    if index == len(items):
        return [], 0

    name, value, weight, _ = items[index]

    # Case 1. Don't take the item
    sol_without, val_without = kim_helper(items, index + 1, capacity, memo)

    # Case 2. Take the item
    if weight <= capacity:
        sol_with, val_with = kim_helper(items, index + 1, capacity - weight, memo)
        sol_with = sol_with + [name]  # need to make new list, due to memoization
        val_with += value
    else:
        sol_with = []
        val_with = 0

    # Compare Case 1 and Case 2, take the maximum
    if val_with > val_without:
        answer = sol_with, val_with
    else:
        answer = sol_without, val_without
    memo[index, capacity] = answer
    return answer


################################
# Knapsack Tabulation Review
################################
def knapsack_indexed_tabular_values(items, capacity):
    # initialize table of subproblem VALUES
    n = len(items)
    table = [[0 for _ in range(capacity + 1)] for _ in range(n + 1)]

    # base case is encoded in last row, where index == len(items)

    # fill in table with VALUES only
    for i in range(n - 1, -1, -1):
        name, value, weight, _ = items[i]

        for cap in range(capacity + 1):

            # Case 1: Dont take the item
            val_without = table[i + 1][cap]

            # Case 2: Take the item
            if weight <= cap:
                val_with = table[i + 1][cap - weight] + value
            else:
                val_with = 0

            if val_with > val_without:
                table[i][cap] = val_with
            else:
                table[i][cap] = val_without

    # trace through values to find items in the optimal solution
    solution = []
    total_value = table[0][capacity]

    remaining = capacity
    for i in range(0, n):
        # values stay the same down one column only if optimal NOT to take an item
        if table[i][remaining] == table[i + 1][remaining]:
            continue
        else:
            name, value, weight, _ = items[i]
            solution.append(name)
            remaining -= weight

    return solution, total_value


items = [
    ("laptop", 3000, 3, 3000/3),       # density = 1000
    ("book", 500, 1, 500/1),           # density = 500
    ("camera", 1500, 2, 1500/2),       # density = 750
    ("headphones", 400, 1, 400/1),     # density = 400
    ("water", 100, 2, 100/2),          # density = 50
]

capacity = 4

solution, total_value = knapsack_indexed_memoized(items, capacity)
print(solution, total_value)
solution, total_value = knapsack_indexed_tabular_values(items, capacity)
print(solution, total_value)

# where density fails

items = [
    ("A", 10, 2, 5.0), # highest density
    ("B", 19, 4, 4.75),
    ("C", 18, 4, 4.5),
]
capacity = 4

solution, total_value = knapsack_indexed_memoized(items, capacity)
print(solution, total_value)
solution, total_value = knapsack_indexed_tabular_values(items, capacity)
print(solution, total_value)


#########################################################################
# Exercise 1: Minimum edit distance between strings using memoization
#########################################################################

def min_edit_distance_memo(str1, str2):
    """
    Computes the minimum edit distance between two strings using memoization.

    The edit distance is the minimum number of single-character operations
    required to transform str1 into str2. The allowed operations are:
        - insertion
        - deletion
        - replacement

    Parameters
    ----------
    str1 : str
        The original string we want to edit.
    str2 : str
        The target string we want str1 to match.

    Returns
    -------
    int
        The minimum number of edits required to convert str1 into str2.
    """
    memo = {}
    return min_edit_distance_memo_helper(str1, str2, 0, 0, memo)


def min_edit_distance_memo_helper(str1, str2, i, j, memo):
    """
    A recursive helper for min_edit_distance_memo() that computes the edit distance
    between the suffixes str1[i:] and str2[j:] using memoization.

    Parameters:
    str1 : str
        The original string
    str2 : str
        The target string
    i : int
        Current index in str1 (we are considering the substring str1[i:])
    j : int
        Current index in str2 (we are considering the substring str2[j:])
    memo : dict
        A dictionary used for memoization. It should map pairs (i, j) to the
        minimum number of edits needed to convert str1[i:] into str2[j:]

    Returns
    -------
    The minimum number of edits needed to transform str1[i:] into str2[j:].
    """
    # Check if result is already in memo
    if (i, j) in memo:
        return memo[i, j]

    # Base cases
    if i == len(str1):
        # If str1 is exhausted, we need to insert all remaining characters of str2
        return len(str2) - j
    if j == len(str2):
        # If str2 is exhausted, we need to delete all remaining characters of str1
        return len(str1) - i

    if str1[i] == str2[j]:
        # Characters match, move to the next pair
        result = min_edit_distance_memo_helper(str1, str2, i + 1, j + 1, memo)
    else:
        # Characters do not match, consider all three operations
        insert_cost = 1 + min_edit_distance_memo_helper(str1, str2, i, j + 1, memo)  # Insertion
        delete_cost = 1 + min_edit_distance_memo_helper(str1, str2, i + 1, j, memo)  # Deletion
        replace_cost = 1 + min_edit_distance_memo_helper(str1, str2, i + 1, j + 1, memo)  # Replacement

        result = min(insert_cost, delete_cost, replace_cost)

    # Store result in memo before returning
    memo[i, j] = result
    return result

# example usage
print(min_edit_distance_memo("abc", "abc"))  # Expected output: 0
print(min_edit_distance_memo("", "abc"))  # Expected output: 3
print(min_edit_distance_memo("kitten", "sitting"))  # Expected output: 3
print(min_edit_distance_memo("intention", "execution"))  # Expected output: 5

#########################################################################
# Exercise 2: Minimum edit distance between strings using tabulation
#########################################################################

def min_edit_distance_tabular(str1, str2):
    """
    Computes the minimum edit distance between two strings using memoization.

    The edit distance, parameters and returns are the same as defined in min_edit_distance_memo().
    """
    n = len(str1)
    m = len(str2)

    # Initialize the DP table
    table = [[0 for _ in range(m + 1)] for _ in range(n + 1)]

    # Base cases: transforming empty str1 to str2 and vice versa
    for i in range(n + 1):
        table[i][m] = n-i  # Deleting all characters from str1
    for j in range(m + 1):
        table[n][j] = m-j  # Inserting all characters to str1 to form str2

    # Fill the DP table from bottom up (reverse order)
    for i in range(n - 1, -1, -1):
        for j in range(m - 1, -1, -1):
            if str1[i] == str2[j]:
                table[i][j] = table[i + 1][j + 1]  # No operation needed
            else:
                insert_cost = 1 + table[i][j + 1]    # Insertion
                delete_cost = 1 + table[i + 1][j]    # Deletion
                replace_cost = 1 + table[i + 1][j + 1]  # Replacement

                table[i][j] = min(insert_cost, delete_cost, replace_cost)

        # You can also fill the DP table up the other way:
        # Fill the DP table (forward order)
        # for i in range(1, n + 1):
        #     for j in range(1, m + 1):
        #         if str1[i - 1] == str2[j - 1]:
        #             table[i][j] = table[i - 1][j - 1]  # No operation needed
        #         else:
        #             insert_cost = 1 + table[i][j - 1]    # Insertion
        #             delete_cost = 1 + table[i - 1][j]    # Deletion
        #             replace_cost = 1 + table[i - 1][j - 1]  # Replacement

        #             table[i][j] = min(insert_cost, delete_cost, replace_cost)
    # print(table)
    return table[0][0]

# example usage
print(min_edit_distance_tabular("abc", "abc"))  # Expected output: 0
print(min_edit_distance_tabular("", "abc"))  # Expected output: 3
print(min_edit_distance_tabular("kitten", "sitting"))  # Expected output: 3
print(min_edit_distance_tabular("intention", "execution"))  # Expected output: 5
