""" 
[ cmd [mac]/ctrl[windows] + click to open ]
- Some slides from sec1: https://docs.google.com/presentation/d/1mVW1SycCWBUIeE4zcL3dw_xHiL9ygZ9KJqN2BF93Lzk/edit?slide=id.p#slide=id.p
- environment diagram visualization: https://pythontutor.com/python-compiler.html#mode=edit
- Dijkstra's visualization: https://www.cs.usfca.edu/~galles/visualization/Dijkstra.html
- DFS/BFS visualization: https://visualgo.net/en/dfsbfs



If you have any questions throughout the long weekend, feel free to email us or post on piazza! 
- Disha's Email: dishakl@mit.edu
- Arianna's Email: acscott@mit.edu
"""

# Warm Up Task: Env Diagrams
# What frame is x in? What about f and g?
x = 5

def f(y):
    x = y + 1
    # We return the output of another function here,
    # what does that mean about when the function call ends?
    return g(x)

def g(z):
    # What is x here? Where do we have to find it?
    return x + z

print(f(3))

# Answer: See image in sec3 folder for environment diagram


# Task 1: Understand Function Calls w/ Classes
"""
Given the code below, how many calls to an __eq__() method are made when
evaluating the expression Point3D(0, 0, 0) == Point3D(0, 0, 0)?

Answer: 5

1. Point3D(0, 0, 0) == Point3D(0, 0, 0)     [calls __eq__() for Point3D]

This calls these two:
2. Point.__eq__(self, other)                [calls __eq__() for Point]
3. self.z == other.z                        [calls __eq__() for int or float, depending on z's type]

Evaluating Point.__eq__(self, other) results in two more calls:
4. self.x == other.x                        [calls __eq__() for int or float, depending on x's type]
5. self.y == other.y                        [calls __eq__() for int or float, depending on y's type]

All types are classes! The base class for all other classes is the object class.
"""
class Point:
    """A Point is a location in two-dimensional Euclidean space."""

    def __init__(self, x, y):
        """
        Initialize a Point at numeric x- and y-coordinates (given as ints or floats).
        Once initialized, a Point should not change location.
        """
        self.x = x
        self.y = y

    def __str__(self):
        return f"<{self.x}, {self.y}>"

    def __eq__(self, other):
        """Two Points are identical if they have the same x- and y-coordinates."""
        return self.x == other.x and self.y == other.y

    def get_x(self):
        return self.x

    def get_y(self):
        return self.y

    def get_distance(self, other):
        """Return the magnitude of the distance between two Points."""
        dx = self.x - other.x
        dy = self.y - other.y
        return (dx ** 2 + dy ** 2) ** 0.5

class Point3D(Point):

    def __init__(self, x, y, z):
        Point.__init__(self, x, y)
        self.z = z

    def __eq__(self, other):
        return Point.__eq__(self, other) and self.z == other.z


# Task 2: Using BFS w/ Classes
"""
Recall that within a tree, there is a unique path form the root to every node. Given a unweighted,
directed graph that is a tree, and given two nodes in it, find their latest common ancestor.
i.e., determine the node that is on both paths from the root to the given nodes and is
farthest from the root.

The Digraph class and bfs() function below are available for your use.
"""
## DO NOT MODIFY
class Digraph:
    def __init__(self, nodes=()):
        self._edges = {}
        for node in nodes:
            self.add_node(node)
    def add_node(self, node):
        if node in self._edges:
            raise ValueError("Duplicate node")
        self._edges[node] = {}
    def add_edge(self, src, dest, weight=1):
        if src not in self._edges:
            self.add_node(src)
        if dest not in self._edges:
            self.add_node(dest)
        self._edges[src][dest] = weight
    def has_node(self, node):
        return node in self._edges
    def get_all_nodes(self):
        return list(self._edges.keys())
    def outgoing_edges_of(self, node):
        return self._edges[node].copy()
    def children_of(self, node):
        return list(self.outgoing_edges_of(node).keys())
    def __str__(self):
        vals = []
        for src in self._edges:
            entry = src + ": "
            for dest, weight in self._edges[src].items():
                entry += f"{dest}({weight}), "
            if entry[-2:] != ": ": # There was at least one edge
                vals.append(entry[:-2])
            else:
                vals.append(entry[:-1])
        vals.sort(key=lambda x: x.split(":")[0])
        result = ""
        for v in vals:
            result += v + "\n"
        return result[:-1]

def bfs(graph, source, target):
    """
    Find a shortest unweighted path from node source to node target in a
    directed graph. Return the path as a list of nodes starting from
    source, or return None if there is no such path.
    """
    queue = [[source]]
    visited = set()
    visited.add(source)

    while queue:
        path = queue.pop(0)
        last_node = path[-1]
        for next_node in graph.children_of(last_node):
            if next_node in visited:
                continue
            new_path = path + [next_node]
            visited.add(next_node)
            if next_node == target:
                return new_path
            queue.append(new_path)
    return None

## IMPLEMENT THIS FUNCTION
def find_common_ancestor(tree, root, node1, node2):
    """
    Parameters:
        tree (Digraph): A directed graph in tree form with at least two
            nodes. All nodes are str objects.
        root (str): The root node of the tree.
        node1 (str): Any node in the tree.
        node2 (str): Any other node in the tree, distinct from node1.

    Return the node (str) that is node1 and node2's latest common ancestor.
    """
    # TODO implement this function!
    node1_ancestors = bfs(tree, root, node1)[::-1]
    node2_ancestors = bfs(tree, root, node2)[::-1]
    
    for ancestor1 in node1_ancestors:
        if ancestor1 in node2_ancestors:
            return ancestor1
        
    return root

# For example:
tree = Digraph()
tree.add_edge("A", "B1")
tree.add_edge("A", "B2")
tree.add_edge("B1", "C1")
tree.add_edge("B1", "C2")
tree.add_edge("B2", "C3")
tree.add_edge("C1", "D1")
tree.add_edge("C2", "D2")
tree.add_edge("C2", "D3")
tree.add_edge("C3", "D4")
tree.add_edge("C3", "D5")
print(find_common_ancestor(tree, "A", "D1", "D3"))  # prints "B1"
print(find_common_ancestor(tree, "A", "D1", "C3"))  # prints "A"

# Task 3: Exceptions
"""
Recall this function from Pset 2; can we now implement it in a cleaner way?
"""
def clean_data(x_vals, y_vals):
    """
    Discard malformed entries from a dataset.

    Parameters:
        x_vals (list): Contains strs representing the x-values of a dataset.
        y_vals (list): Contains strs representing the y-values of a dataset.

    Any entry in x_vals that does not represent a valid number should be
    discarded along with the corresponding entry in y_vals, and vice versa.
    These values should be deleted from the input lists directly.
    """
    for i in range(len(x_vals)-1, -1, -1): #iterate backwards
        #if datapoint cannot be turned into float, delete from x and y lists
        try:
            float(x_vals[i])
            float(y_vals[i])
        except (ValueError, TypeError):
            x_vals.pop(i)
            y_vals.pop(i)
    
x_vals = [1, [2.5, 3], "$", "2.5"]
y_vals = ["*", 3.2, "hello", ".05"]
print(f"Original x_vals: {x_vals}")
print(f"Original y_vals: {y_vals}")

clean_data(x_vals, y_vals)
print(f"Cleaned x_vals: {x_vals}") #should be ["2.5"]
print(f"Cleaned y_vals: {y_vals}") #should be [".05"]


# Task 4: BFS/DFS Conceptual Question 
"""
Let G be a digraph in which each edge has the same weight. P_breadth is
the first path from node n1 to node n2 found with breadth first search, and
P_depth is the first path from node n1 to node n2 found with depth first
search. Which of the following must be true? Check all that apply:
A - The sum of the edge weights in P_depth is greater than the sum of the edge
    weights in P_breadth.
B - Fewer nodes are explored to find P_breadth than to find P_depth
C - P_breadth is a shortest path between n1 and n2.
D - P_depth is a shortest path between n1 and n2.
"""

##### THIS IS A FINGER EX! SOLVE IT YOURSELF :P #####