# pretty please don't peek at solutions during recitation ty

#####################################################
# Function Calls, Scope, Environment Diagrams
#####################################################

"""
Consider the following code, which is a partial implementation of a point in
three-dimensional space.

How many variables are created in the local context of Point3D.__init__() when
evaluating the expression Point3D(0, 0, 0)?

Answer: 4
- Point3D(0, 0, 0) calls Point3D.__init__(self, 0, 0, 0), which creates a new function frame
- Four local variables are created in this frame:
    - self -> the newly created Point3D object
    - x -> 0
    - y -> 0
    - z -> 0
- Calling Point.__init__(self, x, y) creates a new frame with variables self -> object, x -> 0 and y -> 0, but
    these are outside of our local frame
- self.z = z adds an instance attribute to the object, but does not add a local variable to our local frame
"""

class Point:
    """A Point is a location in two-dimensional Euclidean space."""

    def __init__(self, x, y):
        """
        Initialize a Point at numeric x- and y-coordinates (given as ints or floats).
        Once initialized, a Point should not change location.
        """
        self.x = x
        self.y = y

    def __str__(self):
        return f"<{self.x}, {self.y}>"

    def __eq__(self, other):
        """Two Points are identical if they have the same x- and y-coordinates."""
        return self.x == other.x and self.y == other.y

    def get_x(self):
        return self.x

    def get_y(self):
        return self.y

    def get_distance(self, other):
        """Return the magnitude of the distance between two Points."""
        dx = self.x - other.x
        dy = self.y - other.y
        return (dx ** 2 + dy ** 2) ** 0.5

class Point3D(Point):

    def __init__(self, x, y, z):
        Point.__init__(self, x, y)
        self.z = z

    def __eq__(self, other):
        return Point.__eq__(self, other) and self.z == other.z



"""
Given the Point3D code above, how many calls to an __eq__() method are made when
evaluating the expression Point3D(0, 0, 0) == Point3D(0, 0, 0)?

Answer: 5

1. Point3D(0, 0, 0) == Point3D(0, 0, 0)     [calls __eq__() for Point3D]

This calls these two:
2. Point.__eq__(self, other)                [calls __eq__() for Point]
3. self.z == other.z                        [calls __eq__() for int or float, depending on z's type]

Evaluating Point.__eq__(self, other) results in two more calls:
4. self.x == other.x                        [calls __eq__() for int or float, depending on x's type]
5. self.y == other.y                        [calls __eq__() for int or float, depending on y's type]

All types are classes! The base class for all other classes is the object class.
"""


#####################################################
# BFS, DFS, Dijkstra's
#####################################################

"""
Let G be a digraph in which each edge has the same weight. P_breadth is
the first path from node n1 to node n2 found with breadth first search, and
P_depth is the first path from node n1 to node n2 found with depth first
search. Which of the following must be true? Check all that apply:
A - The sum of the edge weights in P_depth is greater than the sum of the edge
    weights in P_breadth.
B - Fewer nodes are explored to find P_breadth than to find P_depth
C - P_breadth is a shortest path between n1 and n2.
D - P_depth is a shortest path between n1 and n2.
"""
# answer redacted - finger exercise


"""
Which of the following are true? Check all that apply.
A -	Dijkstra's algorithm is more efficient than DFS at finding shortest paths on
    weighted graphs because it doesn't need to consider all neighbors of each node.
B -	When Dijkstra's algorithm terminates, any node with distance infinity must be
    unreachable from the start.
C -	In Dijkstra's algorithm, once we explore the outgoing edges of a node, we have
    found the shortest distance from the start to that node.

Answer: B, C

A — False: Dijkstra’s algorithm still considers all neighbors.
    Its efficiency comes from prioritizing nodes by tentative distance, not by skipping neighbors.
B — True: If a node’s distance remains infinity when the algorithm ends, no path from the start node can reach it.
C — True: In Dijkstra’s algorithm, when a node is removed from the priority queue (i.e., explored),
    its shortest distance from the start is finalized. If there existed a shorter path to that node
    from the start, it would have been removed from the priority queue earlier!
"""

"""
Recall that within a tree, there is a unique path form the root to every node. Given a unweighted,
directed graph that is a tree, and given two nodes in it, find their latest common ancestor.
i.e., determine the node that is on both paths from the root to the given nodes and is
farthest from the root.

The Digraph class and bfs() function below are available for your use.
"""
## DO NOT MODIFY
class Digraph:
    def __init__(self, nodes=()):
        self._edges = {}
        for node in nodes:
            self.add_node(node)
    def add_node(self, node):
        if node in self._edges:
            raise ValueError("Duplicate node")
        self._edges[node] = {}
    def add_edge(self, src, dest, weight=1):
        if src not in self._edges:
            self.add_node(src)
        if dest not in self._edges:
            self.add_node(dest)
        self._edges[src][dest] = weight
    def has_node(self, node):
        return node in self._edges
    def get_all_nodes(self):
        return list(self._edges.keys())
    def outgoing_edges_of(self, node):
        return self._edges[node].copy()
    def children_of(self, node):
        return list(self.outgoing_edges_of(node).keys())
    def __str__(self):
        vals = []
        for src in self._edges:
            entry = src + ": "
            for dest, weight in self._edges[src].items():
                entry += f"{dest}({weight}), "
            if entry[-2:] != ": ": # There was at least one edge
                vals.append(entry[:-2])
            else:
                vals.append(entry[:-1])
        vals.sort(key=lambda x: x.split(":")[0])
        result = ""
        for v in vals:
            result += v + "\n"
        return result[:-1]

def bfs(graph, source, target):
    """
    Find a shortest unweighted path from node source to node target in a
    directed graph. Return the path as a list of nodes starting from
    source, or return None if there is no such path.
    """
    queue = [[source]]
    visited = set()
    visited.add(source)

    while queue:
        path = queue.pop(0)
        last_node = path[-1]
        for next_node in graph.children_of(last_node):
            if next_node in visited:
                continue
            new_path = path + [next_node]
            visited.add(next_node)
            if next_node == target:
                return new_path
            queue.append(new_path)
    return None

## IMPLEMENT THIS FUNCTION
def find_common_ancestor(tree, root, node1, node2):
    """
    Parameters:
        tree (Digraph): A directed graph in tree form with at least two
            nodes. All nodes are str objects.
        root (str): The root node of the tree.
        node1 (str): Any node in the tree.
        node2 (str): Any other node in the tree, distinct from node1.

    Return the node (str) that is node1 and node2's latest common ancestor.
    """
    path1 = bfs(tree, root, node1)
    path2 = bfs(tree, root, node2)
    for index, (n1, n2) in enumerate(zip(path1, path2)):
        if n1 != n2:
            break
    return path1[index - 1]

# For example:
tree = Digraph()
tree.add_edge("A", "B1")
tree.add_edge("A", "B2")
tree.add_edge("B1", "C1")
tree.add_edge("B1", "C2")
tree.add_edge("B2", "C3")
tree.add_edge("C1", "D1")
tree.add_edge("C2", "D2")
tree.add_edge("C2", "D3")
tree.add_edge("C3", "D4")
tree.add_edge("C3", "D5")
print(find_common_ancestor(tree, "A", "D1", "D3"))  # prints "B1"
print(find_common_ancestor(tree, "A", "D1", "C3"))  # prints "A"

#####################################################
# Monte Carlo
#####################################################
"""
Personnel at a certain company are classified as Employees, Managers, or Vice Presidents.

At the end of each workday, an Employee has a prob_em chance of being promoted to Manager.

Similarly, a Manager has a prob_mv chance of being promoted to Vice President after any
given day, but also a prob_me chance of demotion back to Employee, where prob_mv + prob_me <= 1.

Implement in the function below a Monte Carlo simulation that estimates how many days on
average it takes a new Employee to become a Vice President.
"""
import random

def estimate_timeline(prob_em, prob_mv, prob_me, num_trials):
    """
    Run a Monte Carlo simulation of num_trials trials to estimate how
    many days on average it takes a new Employee to become a Vice
    President. The parameters prob_em, prob_mv, and prob_me represent
    the promotion and demotion probabilities described above.
    """
    # add your code below
    durations = []
    EMPLOYEE, MANAGER, VP = "employee", "manager", "vice president"
    for _ in range(num_trials):
        status = EMPLOYEE
        days = 0
        while status != VP:
            sample = random.random()
            if status == EMPLOYEE:
                if sample < prob_em:
                    status = MANAGER
            elif status == MANAGER:
                if sample < prob_mv:
                    status = VP
                elif sample < prob_mv + prob_me:
                    status = EMPLOYEE
            days += 1
        durations.append(days)
    return sum(durations) / len(durations)

# For example:
print(estimate_timeline(1, 1, 0, num_trials=100))           # exactly 2
print(estimate_timeline(1, 0.5, 0, num_trials=1000))        # close to 3
print(estimate_timeline(1, 0.5, 0.5, num_trials=1000))      # close to 4
print(estimate_timeline(0.1, 0.1, 0.1, num_trials=1000))    # close to 30

"""
Implement the function that meets the specification below.
Include your entire function definition: header and body. You may also include helper functions if desired.
You may assume random and numpy are imported for you.
The grader test cases check the two parts of the returned tuple separately.

Your code may fail some tests simply due to randomness, so the test results for this question are only a guideline.
"""
import random
def eval_guesser(num_trials, num_guesses, guesser, checker):
    """
    * num_trials is a positive int
    * num_guesses is a positive int
    * guesser is a stochastic function that takes no arguments and returns an int
    * checker is a deterministic function that takes in an int and returns a Boolean

    Run num_trials of a Monte Carlo simulation that consists of num_guesses.
    Each simulation estimates the probability that guesser outputs a guess
    on which checker will return True.

    Return the mean of the estimates
    """
    # your code here
    estimates = []
    for _ in range(num_trials):
        successes = 0
        for _ in range(num_guesses):
            if checker(guesser()):
                successes += 1
        estimates.append(successes / num_guesses)
    return sum(estimates)/len(estimates)

# For example:
# prints something close to (0.5)
print(eval_guesser(100, 50, lambda: random.randint(1, 10), lambda x: x <= 5))

# prints (1.0)
print(eval_guesser(100, 50, lambda: random.randint(5, 50), lambda x: x <= 51))


"""
Consider the following code, which implements the throwing needles simulation you saw
in class applied to some function. Assume the function is in the positive x-y quadrant.

def throw_needles(f, xmin, xmax, needles = 1000):
     under = 0
     ymax = f(xmax)
     for x in range(xmin, xmax):
          if f(x) > ymax:
               ymax = f(x)
     for n in range(needles):
          x = xmin + random.random()*(xmax-xmin)
          y = random.random()*ymax
          if y < f(x):
               under += 1
     return (under/needles)

def perform_sim(f, trials=100, needles=1000):
     res = []
     for t in range(trials):
          res.append(throw_needles(f, 0, 100, needles))
     mean = sum(res)/len(res)


Which of the following are true? Check all that apply.
A - Suppose the call perform_sim(lambda x: 25) is made. Right before it returns, the value of mean is 25.
B - Suppose the call perform_sim(lambda x: 25) is made. Right before it returns, max(res) == min(res).
C - Suppose the call perform_sim(lambda x: x) is made. Right before it returns, the expected value of mean is 0.5.
D - Suppose the call perform_sim(lambda x: x) is made. Right before it returns, the maximum value in res could be 100.
E - Suppose the call perform_sim(lambda x: x) is made. Right before it returns, the distribution of values in res looks
    more like a Gaussian distribution than a uniform distribution.

Answer: B,C,E

A — False: Any call f(x) always returns 25, so f(x) == y_max == 25.
    y = random.random()*ymax will (realistically) result in y < 25.
    Thus throw_needles always returns 1.0, so mean will be 1.0, not 25.
B — True: For the constant function every trial produces the same result 1.0, so max(res) == min(res).
C - True: For the line f(x)=x in the positive x-y quadrant, approximately half the needles thrown at the
    positive x-y quadrant will fall below the line.
D - False: Each entry of res is a fraction under/needles between 0 and 1, so no element of res can equal 100.
E - True: Each trial's result is a sample proportion which is stored in res. Because these proportions
    can vary per trial due to randomness, the distribution will be more Gaussian and not uniform.
"""

#####################################################
# Random Walks
#####################################################

"""
Which of the following are true? Check all that apply.

A - Random walks can be used to model some physical processes.
B - A random walk is a stochastic process.
C - Consider a random walk that takes one step with equal probability in each of four
    directions (north, south, east, or west). Given a large number of trials of this
    random walk from the same starting position, the average of all ending positions
    will most likely be near the starting point.
D - Consider a random walk that takes one step with a 0.3 probability in the north and
    south directions, and 0.2 probability in the east and west directions. Given a
    large number of trials of this random walk from the same starting position, the
    average of all ending positions will most likely be near the starting point.

Answer: A,B,C,D

A — True: Random walks model many physical processes (e.g., diffusion, Brownian motion)
    where particles move in successive random steps.
B — True: A random walk is a stochastic process because its evolution is governed by random variables.
C — True: With equal step probabilities the expected displacement after one step is zero,
    so the average of many trials will concentrate near the start by the law of large numbers.
D — True: Even with unequal per-direction probabilities (0.3,0.3,0.2,0.2),
    the expected x- and y-displacements are each zero, so the mean of many trials will still
    be near the starting point.
"""

"""
Which of the following are true? Check all that apply.
A -	If you run a Python function repeatedly but cannot see its source code, it could be
    impossible to tell whether it is stochastic or deterministic.
B -	In the generalized birthday problem from lecture, to estimate the likelihood that
    out of n people there are k people who share a birthdate, each trial in our simulation
    involves sampling exactly n birthdates.
C -	In a random walk, the location after n steps is independent of the location after
    n + 1 steps.

Answer: A,B

A — True: Without seeing the code or controlling randomness, you can’t know whether a function’s output
    varies unpredictably (stochastic) or is fixed (deterministic).
B — True: Each trial of the generalized birthday simulation draws exactly (n) random birthdates to test
    for shared dates among those (n) people.
C — False: In a random walk, the position after (n + 1) steps directly depends on the position after (n)
    steps, since each new step starts from the previous location.

"""

"""
Implement the function that meets the specification below.

Include your entire function definition: header and body. You may also include helper
functions if desired.

The test results for this question are only a guideline.

For example, consider a scenario where leftbound = -1 and rightbound = 1.
Suppose a walk of n = 4 steps results in the sequence of locations 0 → -1 → -1 → 0 → 1.
This would count as three wall hits, with a final location of 1.
"""
import random
random.seed(0)

def walk(n, leftbound, rightbound, leftbias=0.5):
    """
    * n is a positive int (> 0)
    * leftbound is a negative int (< 0)
    * rightbound is a positive int (> 0)
    * leftbias is a float between 0 and 1 inclusive

    Perform a random walk of n steps along the real number line,
    starting from 0. Each step attempts to go either left (-1) with
    probability leftbias, or right (+1) otherwise.

    The walk may go up to, but not beyond, leftbound or rightbound.
    Attempting to go left while at leftbound leaves the location unchanged;
    similarly for going right at rightbound. Each time step for which
    the walk reaches or remains at either bound counts as a wall hit.

    At the end of the walk, return a tuple with two ints:
        * the number of wall hits
        * the final location
    """
    pass
    # answer redacted - finger exercise

#####################################################
# Classes + Inheritance
#####################################################
class UniqueItems(object):
    """ A group of items that contains NO DUPLICATES """
    def __init__(self, items):
        """ items is a list """
        # your code here
        self.items = []
        for e in items:
            if e not in self.items:
                self.items.append(e)

    def add_item(self, item):
        """ Adds items to self """
        # your code here
        if item not in self.items:
            self.items.append(item)

    def remove_item(self, item):
        """ Removes item from self """
        # your code here
        self.items.remove(item)

    def get_items(self):
        """ Returns a list of items in self, in sorted order """
        # your code here
        return sorted(self.items)

    def __str__(self):
        """ Returns a str representing the sorted group of items in self,
            separated by commas and then a space """
        # your code here
        sitems = sorted(self.items)
        ret = ""
        for e in sitems:
            ret += str(e)+', '
        return ret[:-2]

# Examples
u1 = UniqueItems([4,6,2,4,6,4])
print(u1.get_items())   # prints [2, 4, 6]
u1.add_item(6)
print(u1.get_items())   # prints [2, 4, 6]
u1.add_item(0)
print(u1.get_items())   # prints [0, 2, 4, 6]
u1.remove_item(2)
print(u1.get_items())   # prints [0, 4, 6]
print(u1)               # prints 0, 4, 6


#####################################################
# Exceptions
#####################################################
"""
A rooted binary tree is an acyclic (no cycles) directed graph in which there is exactly one node
(the root) with no parents each non-root node has exactly one parent each node has at
most two children a childless node is called a leaf.

Implement the function that meets the specification below.
"""
## DO NOT MODIFY THIS CLASS
class Node:
    def __init__(self, value, left_child=None, right_child=None):
        """ Constructs an instance of Node
        Inputs:
            value: An object, the value held by this node
            left_child: A Node object if this node has a left child, None otherwise
            right_child: A Node object if this node has a right child, None otherwise """
        if isinstance(left_child, Node):
            self.left = left_child
        elif left_child == None:
            self.left = None
        else:
            raise TypeError("Left child not an instance of Node")

        if isinstance(right_child, Node):
            self.right = right_child
        elif right_child == None:
            self.right = None
        else:
            raise TypeError("Right child not an instance of Node")

        self.value = value

    def get_left_child(self):
        """ Returns this node's left child if present. None otherwise """
        return self.left

    def get_right_child(self):
        """ Returns this node's right child if present. None otherwise """
        return self.right

    def get_value(self):
        """ Returns the object held by this node """
        return self.value

    def is_leaf(self):
        """ Returns True if both children are None and False otherwise """
        return (self.left == None) and (self.right == None)


## IMPLEMENT THIS FUNCTION
def get_size(t):
    """t is a Node object representing the root of a binary tree
       Return the number of Nodes in the tree rooted at t."""
    pass
# answer redacted - finger exercise


# For example:
tree1 = Node(8, Node(2, Node(1), Node(5)), Node(10))
print(get_size(tree1))  # prints 5

tree2 = Node(7, Node(2, Node(1), Node(5, Node(4), Node(6))), Node(9, Node(8), Node(10)))
print(get_size(tree2))  # prints 9


"""
Fix the function below so it matches the doc string
"""
def f(L, val):
    """
    L is a non-empty list of ints
    val is a positive int

    Raise an assertion error if the list is empty
    Raise an assertion error if val is not an integer
    Raise an assertion erorr if any elements of L are not an integer

    If all elements in L are less than val, returns their average.
    If at least one element in L is greater than val, returns False.
    """
    # fix this code
    assert len(L) != 0, 'list is empty' # ADDED
    assert (type(val)==int), 'val is a non-number' # ADDED
    for e in L:
        # ADDED
        assert (type(e)==int), 'non-number found in L' # ADDED
        if e >= val:
            return False
    return sum(L)/len(L)
