# Use this link to visualize enviornmnent diagrams: https://pythontutor.com/python-compiler.html#mode=edit
# Presentation link: https://docs.google.com/presentation/d/1mVW1SycCWBUIeE4zcL3dw_xHiL9ygZ9KJqN2BF93Lzk/edit?usp=sharing

# Reviewing Environment Diagrams
# https://pythontutor.com/render.html#code=x%20%3D%205%0A%0Adef%20f%28y%29%3A%0A%20%20%20%20x%20%3D%20y%20%2B%201%0A%20%20%20%20return%20g%28x%29%0A%0Adef%20g%28z%29%3A%0A%20%20%20%20return%20x%20%2B%20z%0A%0Aprint%28f%283%29%29&cumulative=false&curInstr=0&heapPrimitives=nevernest&mode=display&origin=opt-frontend.js&py=311&rawInputLstJSON=%5B%5D&textReferences=false
# What frame is x in? What about f and g?
x = 5

def f(y):
    x = y + 1
    # We return the output of another function here,
    # what does that mean about when the function call ends?
    return g(x)

def g(z):
    # What is x here? Where do we have to find it?
    return x + z

print(f(3))

# Practice
# https://pythontutor.com/render.html#code=def%20modify_list%28items,%20value%29%3A%0A%20%20%20%20items.append%28value%29%0A%20%20%20%20new_list%20%3D%20%5B1,%202,%203%5D%0A%20%20%20%20items%20%3D%20new_list%20%0A%0Amy_list%20%3D%20%5B10%5D%0Amodify_list%28my_list,%2020%29&cumulative=false&curInstr=7&heapPrimitives=nevernest&mode=display&origin=opt-frontend.js&py=311&rawInputLstJSON=%5B%5D&textReferences=false
# again, what frame is modify_list in?
def modify_list(items, value):
    # what does items point to here?
    # does append mutate or make a new list with the item added?
    items.append(value)
    new_list = [1, 2, 3] # where is this defined?
    # which items is this referring to?
    items = new_list

my_list = [10]
modify_list(my_list, 20)

# if this doesnt make sense: https://pythontutor.com/render.html#code=a%20%3D%20%5B1,%202,%203%5D%0Ab%20%3D%20a%0Ab.append%283%29%0Aprint%28a%29%0Aprint%28b%29%0A%23%20if%20i%20change%20b%0Ab%20%3D%20%5B0,%201,%202%5D&cumulative=false&curInstr=6&heapPrimitives=nevernest&mode=display&origin=opt-frontend.js&py=311&rawInputLstJSON=%5B%5D&textReferences=false
a = [1, 2, 3]
b = a
b.append(3)
print(a)
print(b)
# if i change b,
b = [0, 1, 2]
# does this change a?



# Classes
class Animal:
    def __init__(self, name):
        # what is this called?
        self.name = name
    # what is this called?
    def speak(self):
        return "?"

class Dog(Animal):
    # what did we inherit from Animal?
    # can we inherit this without passing in Animal?
    def speak(self):
        return "Woof!"

class Cat(Animal):
    def speak(self):
        return "Meow!"
# what are the elements of this list?
pets = [Dog("Fido"), Cat("Luna"), Animal("Unknown")]
for p in pets: # what would happen if Animal or Dog didn't have a speak method?
    print(p.name, " says ", p.speak())

# Practice with super
class Vehicle:
    def __init__(self, brand):
        print("Vehicle init")
        self.brand = brand

class Car(Vehicle):
    def __init__(self, brand, model):
        print("Car init")
        super().__init__(brand)
        self.model = model
# what is the order of init functions run when we make a new instance?
car = Car("Toyota", "Camry")




# recursive
def dfs_recurs(graph, start, visited=None):
    if visited is None:
        visited = set()  # Keeps track of visited nodes

    print("Visiting:", start)
    # why is it important that we add nodes to visited?
    visited.add(start)
    for neighbor in graph[start]:
        if neighbor not in visited:
            dfs_recurs(graph, neighbor, visited)

    return visited

def dfs(graph, start):
    visited = set(start)
    queue = [start]
    while queue:
        node = queue.pop()
        print("Visiting:", node)

        for neighbor in graph[node]:
            if neighbor not in visited:
                visited.add(neighbor)
                queue.append(neighbor)

    return visited

# Example graph (undirected)
graph = {
    'A': ['B', 'C'],
    'B': ['D', 'E'],
    'C': ['F'],
    'D': [],
    'E': ['F'],
    'F': []
}

dfs(graph, 'A')

# If we wanted to check if a path exists from source to
# target which algorithm can we use?
# how can we get the function to stop once we get to a certian node?
# which algorithm is best for shortest paths of unweighted graphs?

def bfs(graph, start):
    visited = set(start)
    queue = [start]

    while queue:
        # how does this differ from dfs?
        node = queue.pop(0)
        print("Visiting:", node)

        for neighbor in graph[node]:
            if neighbor not in visited:
                visited.add(neighbor)
                queue.append(neighbor)

    return visited


# Example graph
graph = {
    'A': ['B', 'C'],
    'B': ['D', 'E'],
    'C': ['F'],
    'D': [],
    'E': ['F'],
    'F': []
}

bfs(graph, 'A')


def dijkstra(graph, start):
    visited = set()
    dist = {v: float('inf') for v in graph}
    dist[start] = 0
    while visited != set(graph): # what is this saying about out end condition?
        # why do we pick this specific node? and how does the key work?
        u = min((v for v in graph if v not in visited), key=lambda x: dist[x])
        visited.add(u)
        for v, w in graph[u]:
            if dist[u] + w < dist[v]: # what is this inequality saying?
                dist[v] = dist[u] + w
    return dist

graph = {
    'A': [('B', 2), ('C', 5)],
    'B': [('C', 1), ('D', 3)],
    'C': [('D', 2)],
    'D': []
}
print(dijkstra(graph, 'A'))




# lambda arguments: expression
square = lambda x: x**2
# ^ these are equivalent
def square(x):
    return x**2
print("Output of square")
print(square(5)) # Output: 25

nums = [1, 2, 3, 4]
print("Output of cool ways to use lambda")
print(list(map(lambda x: x**2, nums))) # [1, 4, 9, 16]
print(list(filter(lambda x: x % 2 == 0, nums))) # [2, 4]


# What data type is square?
funcs = [square, lambda x: x**3]
# What is func2 doing?
def func2(func1, num):
    return func1(num)
# Accumulate outputs of funcs
value = 0
for func in funcs:
    value += func2(func, 1)
# A fun exercise would be going through this example and writing out the
# environment diagram. Use this link to walk through and check your answer.



# List Comprehension
squares = [x**2 for x in range(5)]
# ^ these are equivalent
squares2 = []
for x in range(5):
    squares2.append(x**2)
print(squares)
print(squares2)

# With conditions
evens = [x for x in range(10) if x % 2 == 0]
evens2 = [x if x % 2 == 0 else 0 for x in range(10)]
print(evens)
print(evens2)

# Dictionary comprehensions
nums = ["A", "B", "C", "D"]
unique = {i: nums[i] for i in range(len(nums))} # {0: "A", 1: "B", 2: "C", 3: "D"}

squares_dict = {x: x**2 for x in range(3)}
