# Task 1: Design a Car class <3 (guided example)
class Car:
    def __init__(self, init_license, init_color="Maroon", init_make="Ford", init_odometer=0,
                 init_num_seats=4, init_passengers=None):
        self.color = init_color
        self.license = init_license
        self.make = init_make
        self.num_seats = init_num_seats
        # tank starts empty, values range 0 to 1
        self.tank_filled = 0
        if not init_passengers:
            self.passengers = []
        else:
            self.passengers = init_passengers
        self.odometer = init_odometer

    def add_passengers(self, passengers):
        if len(self.passengers) < self.num_seats:
            self.passengers.extend(passengers)
        else:
            print(f"Car {car.license} is at capacity: {self.num_seats}")
    
    # def remove_passenger(self, passenger):
    #     if passenger not in self.passengers:
    #         print(f"{passenger} is not a passenger.")
    #     else:
    #         self.passengers.remove(passenger)

    def fill_tank(self):
        self.tank_filled = 1

    def use_tank(self, quantity_used):
        self.tank_filled = max(0, self.tank_filled - quantity_used)

    # loss function takes distance, returns percentage of fuel lost by driving that distance
    # assume you can drive the distance even if you run out of gas:P
    def drive(self, distance, tank_loss_fn):
        self.update_odometer(distance)
        self.use_tank(tank_loss_fn(distance))

    def update_odometer(self, distance):
        self.odometer += distance

# Task 2: Start a roadtrip!
def roadtrip(passengers, cars):
    for car_num in range(len(cars)):
        cars[car_num].add_passengers([passengers[pass_index] for pass_index in \
                                      range(len(passengers)) if pass_index % len(cars) == car_num])
        
    ####### they are given the following ########

    for car_num in range(len(cars)):
        car_passengers = []
        for pass_index in range(len(passengers)):
            if pass_index % len(cars) == car_num:
                car_passengers.append(passengers[pass_index])
        cars[car_num].add_passengers(car_passengers)
        


# Task 3: Loss function translation
def loss_fn(distance):
    return distance * 0.1 / 15

car1 = Car(init_license="BEAVER", init_odometer=1155)
car2 = Car(init_license="IHTFP", init_num_seats=7)
car3 = Car(init_license="61000", init_color="Black", init_odometer=2939)

cars = [car1, car2, car3]
passengers = ["Arianna", "Disha", "Tony", "Jaclyn", "Kira", "Natalie", "Dani", "Hannah"]

# every car has its own loss fn
# could do lambda functions here
loss_fns = [loss_fn, loss_fn, loss_fn]

# Fill gas before roadtrip starts
for car in cars:
    car.fill_tank()

roadtrip(passengers, cars)

# Who is in each car?
for car in cars:
    print(f"Car {car.license} has {car.passengers}")

# drive each car 112 miles
for car, loss_func in zip(cars, loss_fns):
    car.drive(112, loss_func)
    print(f"Current Car: {car.license}, Odometer Reading: {car.odometer} miles, Tank Left: {round(car.tank_filled * 100)}%")