# Note: we are not using getters and setters here, you will learn more about this next week!

# Task 1: Design a Car class <3 (guided example)
class Car:
        
    def add_passengers(self, passengers):
        """
        passengers: (list) list of strings with names of passengers
        
        updates passengers attribute if car has enough empty seats
        """
        pass

    def fill_tank(self):
        """
        updates proportion of tank filled to be full
        """
        pass

    def use_tank(self, proportion_used):
        """
        quantity_used: (float) proportion of gas used

        updates proportion of gas left in tank
        """
        pass

    def update_odometer(self, distance):
        """
        distance: (int) miles car traveled

        update odometer with distance traveled
        """
        pass

    # This is an example of a higher order function: you can pass in a function to a function
    # Other higher order functions include functions that return functions
    def drive(self, distance, tank_loss_fn):
        """
        *** assume you can drive the distance even if you run out of gas:P **
        distance: (int) miles the car traveled
        tank_loss_fn: (func) loss function takes in an int distance and returns 
            proportion of fuel lost by driving that distance
        """
        pass


# Task 2: Use a list comprehension for the inner for loop instead
# Note: This is NOT a bound method so no self parameter
def roadtrip(passengers, cars):
    """
    passengers: (list) list of strings of passengers
    cars: (list) list of Car instances

    adds passengers to cars in an alternating fashion
    ex: if there are 3 cars, assign first passenger to car 1, second passenger to car 2,
    third passenger to car 3, fourth passenger to car 1, and so on....
    """ 
    for car_num in range(len(cars)):
        car_passengers = []
        for pass_index in range(len(passengers)):
            if pass_index % len(cars) == car_num:
                car_passengers.append(passengers[pass_index])
        cars[car_num].add_passengers(car_passengers)


# Task 3: Write Loss function
def loss_fn(distance):
    """
    distance: (int) miles car has traveled
    returns proportion of fuel lost by driving that distance
    """
    pass

# Task 3.1: Convert loss_fn to lambda function




def demo_roadtrip():

    # Intialize car instances
    car1 = Car(init_license="BEAVER", init_odometer=1155)
    car2 = Car(init_license="IHTFP", init_num_seats=7)
    car3 = Car(init_license="61000", init_color="Black", init_odometer=2939)

    cars = [car1, car2, car3]
    passengers = ["Arianna", "Disha", "Tony", "Jaclyn", "Kira", "Natalie", "Dani", "Hannah"]

    # every car has its own loss fn
    # Task 4: Replace loss_fn with different lambda functions
    loss_fns = [loss_fn, loss_fn, loss_fn]

    # Fill gas before roadtrip starts
    for car in cars:
        car.fill_tank()

    # Start Roadtrip
    roadtrip(passengers, cars)

    # Print who is in each car
    for car in cars:
        print(f"Car {car.license} has {car.passengers}")

    # drive each car 112 miles
    for car, loss_func in zip(cars, loss_fns):
        car.drive(112, loss_func)
        print(f"Current Car: {car.license}, Odometer Reading: {car.odometer} miles, \
              Tank Left: {round(car.tank_filled * 100)}%")

demo_roadtrip()


