# Note: we are not usng getters and setters here, you will learn more about this next week!

# Task 1: Design a Car class <3 (guided example)

### Anatomy of a class ###
# Instance: an object that is part of the class, has all atrtibutes defined in the init of the class
# Attributes vs parameters
# -- attributes and parameters don't need to have the same name
# -- parameters allow you to customize attributes per instance
# -- if you want all instances to have the same value for an attribute, no parameter needed
# self notation: self refers to an instance, the name self is just a convention though
# bound methods = instance.function() #function by itself is not defined
# functions specific to an object of a class, first paramter is always self
# when we do instance becomes the first parameter of self
# give them the init parameters?, have them fill in the rest?

class Car:
    def __init__(self, init_license, init_color="Maroon", init_make="Ford", init_odometer=0,
                 init_num_seats=4, init_passengers=None):
        self.color = init_color
        self.license = init_license
        self.make = init_make
        self.num_seats = init_num_seats
        # tank starts empty, represents proportion of tank full: values range 0 to 1 (1 = 100% full)
        self.tank_filled = 0
        #number of miles car has traveled
        self.odometer = init_odometer
        # Q: Why not just set init_passengers = []?
        # A: This would lead to an aliasing issue. For all instances we make of Car,
        # their passengers attribute would all point to the same list, so they would all
        # have the same passengers
        if not init_passengers:
            self.passengers = []
        else:
            self.passengers = init_passengers


    def add_passengers(self, passengers):
        """
        passengers: (list) list of strings with names of passengers
        updates passengers attribute if car has enough empty seats
        """
        if len(self.passengers) + len(passengers) < self.num_seats:
            self.passengers.extend(passengers)
        else:
            print(f"Car {car.license} is at capacity: {self.num_seats}")


    def fill_tank(self):
        """
        updates proportion of tank filled to be full
        """
        self.tank_filled = 1


    def use_tank(self, proportion_used):
        """
        quantity_used: (float) proportion of gas used
        updates proportion of gas left in tank
        """
        self.tank_filled = max(0, self.tank_filled - proportion_used)


    def update_odometer(self, distance):
        """
        distance: (int) miles car traveled
        update odometer with distance traveled
        """
        self.odometer += distance


    # This is an example of a higher order function: you can pass in a function to a function
    # Other higher order functions include functions that return functions
    def drive(self, distance, tank_loss_fn):
        """
        *** assume you can drive the distance even if you run out of gas:P **
        distance: (int) miles the car traveled
        tank_loss_fn: (func) loss function takes in an int distance and returns
            proportion of fuel lost by driving that distance
        """
        self.update_odometer(distance)
        self.use_tank(tank_loss_fn(distance))


# Task 2: Start a roadtrip!
# Note: This is NOT a bound method so no self parameter
def roadtrip(passengers, cars):
    """
    passengers: (list) list of strings of passengers
    cars: (list) list of Car instances
    adds passengers to cars in an alternating fashion
    ex: if there are 3 cars, assign first passenger to car 1, second passenger to car 2,
    third passenger to car 3,
    """
    ####### they are given the following ########
    for car_num in range(len(cars)):
        car_passengers = []
        for pass_index in range(len(passengers)):
            if pass_index % len(cars) == car_num:
                car_passengers.append(passengers[pass_index])
        cars[car_num].add_passengers(car_passengers)
    for car_num in range(len(cars)):
        cars[car_num].add_passengers([passengers[pass_index] for pass_index in \
                                      range(len(passengers)) if pass_index % len(cars) == car_num])
    
    # Task 2.5: Convert inner loop to list comprehension
    for car_num in range(len(cars)):
        cars[car_num].add_passengers([passengers[pass_index] for pass_index in \
                                      range(len(passengers)) if pass_index % len(cars) == car_num])
        
        
# Task 3: Write Loss function + translation to lambda function
def loss_fn(distance):
    """
    distance: (int) miles car has traveled
    returns proportion of fuel lost by driving that distance
    """
    return distance * 0.1 / 15

# Equivalent lambda
lambda distance: distance * 0.1 / 15


# Given
car1 = Car(init_license="BEAVER", init_odometer=1155)
car2 = Car(init_license="IHTFP", init_num_seats=7)
car3 = Car(init_license="61000", init_color="Black", init_odometer=2939)
cars = [car1, car2, car3]
passengers = ["Arianna", "Disha", "Tony", "Jaclyn", "Kira", "Natalie", "Dani", "Hannah"]

# every car has its own loss fn
# could do lambda functions here, or write separate function definition
# discuss environment diagram here? demonstrates function objects
loss_fns = [loss_fn, loss_fn, loss_fn]
# example lambda function: 
# loss_fns = [lambda x: x * 0.1/15, lambda x: x * 0.1/6, lambda x: x * 0.1/24]
# if you're just using these functions for the code below, you don't necessarily need to name them,
# which is why you might write them as lambda functions


# Fill gas before roadtrip starts
for car in cars:
    car.fill_tank()
roadtrip(passengers, cars)
# Print who is in each car
for car in cars:
    print(f"Car {car.license} has {car.passengers}")

# zip lets you loop over multiple iterables at once
# drive each car 112 miles
for car, loss_func in zip(cars, loss_fns):
    # could also directly put a lambda function below, if each car has the same loss function
    car.drive(112, loss_func)
    print(f"Current Car: {car.license}, Odometer Reading: {car.odometer} miles, Tank Left: {round(car.tank_filled * 100)}%")