##################################################
# Random Walks Review
##################################################

# What are random walks?
# - Starting from a location, choose a random direction to walk at each time step
# - Distribution of direction and speed can be different
    # - Maybe more likely to walk downhill, or maybe Jaclyn's choices of random steps are different from Tony's
# - Varience of final position grows in proportion to the number of steps (and size of those steps)

# Examples of random walks:
# - Google's Page Rank - "important" web pages are ones connected to "important" web pages
# - Modeling changes in stock prices
# - Modeling animal movements, population dynamics, genetic drift, spread of disease...


##################################################
# Higher Order Functions
##################################################


# reviewing lambdas:
def square(x):
    return x * x

# the following is equivalent!
square = lambda x : x * x

# functions are objects! can be assigned to variables, passed as arguments, returned by functions
""" follow along with environment diagram on the board/screen :D (skip if short on time)"""
squared = square
also_squared = squared

# ===========

# cool use case: .sort() and sorted() accept a key function that can be used to sort items in list
# (skip if short on time)
ratings = [("Adventure Time", 5.0), ("Finding Nemo", 4.5), ("Cats", 1.0),
           ("Puss in Boots", 5.0), ("Planes", 3.2), ("Coraline", 4.5)]

# sort by title length
title_len = lambda rating : len(rating[0])
# print(sorted(ratings, key=title_len))

# sort by rating in descending order, breaking ties with title (alphabetical)
rating_alpha = lambda rating : (-rating[1], rating[0])
# print(sorted(ratings, key=rating_alpha))


# TODO: implement get_exp_fn() and modular_add_fn()

def get_exp_fn(power):
    """
    Returns a FUNCTION that raises its input to the specified power.
    """
    # TODO implement get_exp_fn
    pass

def modular_add_fn(b, mod):
    """
    Returns a FUNCTION that adds `b` to a function modulo a specified number `mod`.
    """
    # TODO implement modular_add_fn
    pass

num = 5
cube_fn = get_exp_fn(3)
add_five_mod_ten = modular_add_fn(5, 10)

num = cube_fn(num)  # 125
num = add_five_mod_ten(num)  # 0
print(num)

# ===========

# Image Case example: creating transformation function and applying a list of transformation functions
# Don't need to understand, it's just cool :)
from PIL import Image

def get_horizontal_flip_probability_fn(p):
    """
    Returns a function that flips an image horizontally with probability p.
    """
    def flip_image(image):
        import random
        if random.random() < p:
            return image.transpose(method=Image.FLIP_LEFT_RIGHT)
        else:
            return image
    return flip_image

def get_normalized_image_fn(mean, std):
    """
    Returns a function that normalizes an image with given mean and std.
    """
    def normalize_image(image):
        import numpy as np
        img_array = np.array(image).astype(float)
        img_array = (img_array - mean) / std
        return Image.fromarray(np.uint8(img_array))
    return normalize_image

image = Image.new('RGB', (100, 100), color = 'red')

# Create a list of transformation functions
transformations = [
    get_horizontal_flip_probability_fn(0.5),
    get_normalized_image_fn(128, 64)
]

# Apply list of transformation functions on our image
for transform in transformations:
    image = transform(image)


##################################################
# Classes Overview
##################################################

# Car without classes
charlie = {
    "name": "charlie",
    "location": (0, 0),
    "destination": (100, 100)
}

def move_car(car, dx, dy):
    current_x, current_y = car["location"]
    car["location"] = (current_x + dx, current_y + dy)
    return car["location"]

# Car Class
class Car:
    def __init__(self, name, location, destination):
        assert isinstance(name, str), "Name must be a string"
        assert isinstance(location, tuple) and len(location) == 2, "Location must be a tuple of (x, y)"
        assert isinstance(destination, tuple) and len(destination) == 2, "Destination must be a tuple of (x, y)"

        self.name = name
        self.location = location
        self.destination = destination

    def __str__(self):
        return f"Car {self.name} : at {self.location}/{self.destination}"

    def move(self, dx, dy):
        current_x, current_y = self.location
        self.location = (current_x + dx, current_y + dy)
        return self.location

    def get_name(self):
        return self.name

    def get_distance_to_destination(self):
        location_x, location_y = self.location
        destination_x, destination_y = self.destination
        return ((destination_x - location_x) ** 2 + (destination_y - location_y) ** 2) ** 0.5


bobby = Car("bobby", (20, 30), (50, 60))
bobby.move(-5, 10)

charlie = Car("charlie", (0, 0), (100, 100))
charlie.move(10, 15)

print(bobby)
print(charlie)

# 2. Datastructures

list_example = []
list_example.append(4)
list_example.pop()

dict_example = {}
dict_example["c"] = 3
dict_example.pop("c")

# TODO: implement the Queue class
class Queue:
    def __init__(self):
        raise NotImplementedError("Implement the constructor")

    def push(self, item):
        """
        Push a new item to the back of the queue.
        """
        raise NotImplementedError("Implement the push method")

    def pop(self):
        """
        Removes and returns the item at the front of the queue, if it exists.
        """
        raise NotImplementedError("Implement the pop method")

class Stack:
    def __init__(self):
        raise NotImplementedError("Implement the constructor")

    def push(self, item):
        """
        Push a new item onto the top of the stack.
        """
        raise NotImplementedError("Implement the push method")

    def pop(self):
        """
        Removes and returns the item at the top of the stack, if it exists.
        """
        raise NotImplementedError("Implement the pop method")

class PatrioticMovingAverageTemperature:
    def __init__(self):
        self.items = []
        self.celcius_to_fahrenheit = lambda c: (c * 9/5) + 32

    def add(self, celcius_temperature):
        """
        Parameter celcius_temperature: temperature in Celcius
        """
        raise NotImplementedError("Implement the add method")

    def get_patriotic_average(self):
        """
        Returns the average temperature in Fahrenheit.
        """
        raise NotImplementedError("Implement the get_patriotic_average method")
