# Dijkstra visualization: https://www.cs.usfca.edu/~galles/visualization/Dijkstra.html
# DFS/BFS visualizatioin: https://visualgo.net/en/dfsbfs
# Probability Distributions: https://mathlets.org/mathlets/probability-distributions/

# Presentation: https://docs.google.com/presentation/d/1hlk67uyx1JNTKlqc8TkCpy_NTIfjAgi5XjuJeFaUO5w/edit?usp=sharing

# Videos if you are still confused:
# - Random walks: https://youtu.be/stgYW6M5o4k?si=WqGAkux5KWD1bzEx
# - OOP: https://youtu.be/JeznW_7DlB0?si=IpBOWv4lsZL1CUl7
# - Lambda functions: https://youtu.be/j6FCewxjrBM?si=oAaFcK6ZbJi0zoUr
# - Comprehensions: https://youtu.be/DUnY6l482Lk?si=jjFXnXJhwFCh9SPa
# - DFS: https://youtu.be/Urx87-NMm6c?si=HzRKewCmt8HsQi75
# - BFS: https://youtu.be/HZ5YTanv5QE?si=K5cNOvgoeFts1Ypi

# also look at sec3 code to see another way to apply these topics!!

import matplotlib.pyplot as plt
import random

positions = [0]
for i in range(100):
    positions.append(positions[-1] + random.choice([-1, 1]))

plt.plot(positions)
plt.title("Random Walk of 100 Steps")
plt.xlabel("Step")
plt.ylabel("Position")
plt.show()


class Point:
    # what does init do? what is a dunder?
    def __init__(self, x, y):
        self.x = x # attributes
        self.y = y
        print(f"X value for {self}")
        print(x) # which one of these can we access later?
        print(self.x)

    def move(self, dx, dy):
        self.x += dx
        self.y += dy

# What is 1 here? What is 2?
p = Point(1, 2)
p2 = Point(4, 4)

# Why do we put p. before the move function?
# Why don't we pass in self?

# How can I write move outside of the class?
# def move(_, dx, dy):
#     _.x += dx
#     _.y += dy

p.move(1, -1)
# move(p, 1, -1)

# How do we get values for .x and .y?
print("Points Position")
print(f"{p.x}, {p.y}")
print(f"{p2.x}, {p2.y}")


class RandomWalker:
    def __init__(self):
        # so we can save a variable to be used later...
        self.position = 0

    def step(self):
        # What probability is assigned to -1 and 1?
        # This might help: https://docs.python.org/3/library/random.html#random.choice
        self.position += random.choice([-1, 1])

    def walk(self, steps):
        for _ in range(steps):
            self.step()
# Why didn't we pass anything in here?
rw = RandomWalker()
rw.walk(100)
print("Random Walks Position")
print(rw.position)


# lambda arguments: expression
square = lambda x: x**2
# ^ these are equivalent
def square(x):
    return x**2
print("Output of square")
print(square(5)) # Output: 25

nums = [1, 2, 3, 4]
print("Output of cool ways to use lambda")
print(list(map(lambda x: x**2, nums))) # [1, 4, 9, 16]
print(list(filter(lambda x: x % 2 == 0, nums))) # [2, 4]



# List Comprehension
squares = [x**2 for x in range(5)]
# ^ these are equivalent
squares2 = []
for x in range(5):
    squares2.append(x**2)
print(squares)
print(squares2)

# With conditions
evens = [x for x in range(10) if x % 2 == 0]
evens2 = [x if x % 2 == 0 else 0 for x in range(10)]
print(evens)
print(evens2)

# Dictionary comprehensions
nums = ["A", "B", "C", "D"]
unique = {i: nums[i] for i in range(len(nums))} # {0: "A", 1: "B", 2: "C", 3: "D"}

squares_dict = {x: x**2 for x in range(3)}

# Some good questions to ask:
# - how should I represent a parking lot?
# - how can I tell when a spot is taken?
class ParkingLot:
    def __init__(self, capacity):
        """
        Initialize the parking lot with the given number of spots.
        Spots are numbered from 1 to capacity.
        """
        # what to put here? how do i save a variable to be used later?

    def park(self, license_plate):
        """
        Parks the car in the smallest available spot.
        Returns the spot number if successful, or -1 if full.
        """
        # What does parking mean in your code? How can we find the smallest available spot?

    def leave(self, license_plate):
        """
        Removes the car with the given license plate.
        Returns True if the car was found and removed, False otherwise.
        """
        # what does this mean about what values about the car we need to save?

    def status(self):
        """
        Returns a list of (spot_number, license_plate)
        for all occupied spots, sorted by spot number.

        Hint: enumerate - https://www.geeksforgeeks.org/python/enumerate-in-python/
        """
