class ParkingLot:
    def __init__(self, capacity):
        self.capacity = capacity
        # can also keep length capacity and shift i later
        self.spots = [None] * (capacity + 1)  # 1-indexed

    def park(self, license_plate):
        for i in range(1, self.capacity + 1):
            if self.spots[i] is None:
                self.spots[i] = license_plate
                return i
        return -1

    def leave(self, license_plate):
        for i in range(1, self.capacity + 1):
            if self.spots[i] == license_plate:
                self.spots[i] = None
                return True
        return False

    def status(self):
        return [(i, lp) for i, lp in enumerate(self.spots) if lp is not None]
