import random
import numpy as np
# from rich.progress import track

##################################################
# Stochastic Thinking: Applications of Randomness
##################################################

# Examples of stochastic processes
# - Stochastic gradient descent
# - Temperature parameter in LLMs
# - Randomized algorithms
# - Estimation and Monte Carlo methods

##############################
# Probabilistic Overview
##############################

# 1. If you roll 2 dice, what is the likelihood of getting a sum of 10?
# 2. If you roll 2 dice, what is the probability that at least 1 dice is a 5?

################################
# Probability Code Practice
################################
print('run sec 4 code')
# random.seed(0)

def biased_coin_flip(p):
    """
    Simulates a biased coin flip with a given probability of heads (p).

    Args:
        p: The probability of getting heads (a float between 0 and 1).
    Returns:
        'Heads' if the coin lands heads with probability p, 'Tails' otherwise.
    """
    guess = random.random()
    print('guess', guess)
    if guess < p:
        return 'Heads'
    else:
        return 'Tails'

print(biased_coin_flip(.5))

# random.random returns a float N such that 0.0 <= N < 1.0
def sample_uniform(a,b):
  '''
  Implement random.uniform(a,b)

  return a random float in the interval [a,b] where b > a over a uniform distribution
  '''
  return random.random()*(b-a) + a

print('sample_uniform', sample_uniform(1,2))

################################
# Intro Monte Carlo
################################

def simulate_dice_probability(num_trials):
    """
    Use a simulation to estimate the probability that the sum of 7 dice is divisible by either 5 or 8
    """
    favorable_outcomes = 0
    for _ in range(num_trials):
        dice_sum = sum(random.randint(1, 6) for _ in range(7))
        if dice_sum % 5 == 0 or dice_sum % 8 == 0:
            favorable_outcomes += 1
    return favorable_outcomes / num_trials

print('sim', simulate_dice_probability(1000000))
# actual probability is ~ 0.32495

def estimate_e(num_samples):
    """
    Estimate the mathematical constant e using a Monte Carlo simulation.
    The expected number of uniform(0,1) random variables needed to exceed a sum of 1 is e.

    Args:
        num_samples: The number of random samples to use in the estimation.

    Returns:
        An estimate of the value of e.
    """
    count = 0
    for _ in range(num_samples):
        total = 0
        while total < 1:
            total += random.random()
            count += 1
    return count / num_samples

##################################################
# Monte Carlo Integration
##################################################

# Sample functions to integrate over

def cubic(x):
  return x**3 - 2*x + 1

def gaussian_pdf(x):
  return (1 / (np.sqrt(2 * np.pi))) * np.exp(- (x ** 2) / (2))

# Monte Carlo Integration function 1
def integrate_monte_carlo_bbox(f, a, b, num_needles):
  '''
  Approximates the integral of f over the interval [a,b], where f(x) >=0 for all x
  1. approximate y_max by scanning over [a,b]
  2. simulate throwing num_needles needles in a bounding box
  3. return approximate area
  '''
  y_max = 0
  epsilon = 1e-3

  for i in np.arange(a, b+epsilon, epsilon):
    y_max = max(y_max, f(i))

  needles_under_curve = 0
  for i in range(num_needles):
    x = sample_uniform(a,b)
    y = sample_uniform(0,y_max)

    if y <= f(x): needles_under_curve += 1

  total_area = (b-a)*y_max
  return total_area*(needles_under_curve/num_needles)

# Monte Carlo Integration function 2
def integrate_monte_carlo_rect(f, a, b, num_samples):
  '''
  Approximates the integral of f over the interval [a,b], where f(x) >=0 for all x
  done through riemann sum approximation, where x is randomly sampled
  '''
  area = 0
  for i in range(num_samples):
    x = sample_uniform(a, b)
    area += (b-a)/num_samples * f(x)
  return area