import random

##################################################
# Stochastic Thinking: Applications of Randomness
##################################################

# Examples of stochastic processes
# - Stochastic gradient descent
# - Temperature parameter in LLMs
# - Randomized algorithms
# - Estimation and Monte Carlo methods

##############################
# Probabilistic Overview
##############################

# 1. If you roll 2 dice, what is the likelihood of getting a sum of 10?
# 2. If you roll 2 dice, what is the probability that at least 1 dice is a 5?

################################
# Probability Code Practice
################################

random.seed(0)

def biased_coin_flip(p):
    """
    Simulates a biased coin flip with a given probability of heads (p).

    Args:
        p: The probability of getting heads (a float between 0 and 1).
    Returns:
        'Heads' if the coin lands heads with probability p, 'Tails' otherwise.
    """
    pass

def sample_uniform(a,b):
    '''
    Implement random.uniform(a,b)

    return a random float in the interval [a,b] where b > a over a uniform 
    distribution.
    '''
    pass

################################
# Intro Monte Carlo
################################

def simulate_dice_probability(num_trials):
    """
    Use a simulation to estimate the probability that the sum of 7 dice is 
    divisible by either 5 or 8.
    """
    pass

# answer should be ~0.325
def demo_dice_simulation():
    for num_trials in range(1, 100, 5):
        print(f"When num_trials={num_trials}, " \
              f"probability={simulate_dice_probability(num_trials)}")

demo_dice_simulation()

##################################################
# Monte Carlo Integration
##################################################

# Sample function to integrate over

# what other functions could you use?
def cubic(x):
    return x**3 - 2*x + 1

# Monte Carlo Integration function 1

# why does f(x) need to be >= 0 on all x?
def integrate_monte_carlo_bbox(f, a, b, num_needles):
    '''
    Approximates the integral of f over the interval [a,b], where f(x) >=0 
    for all x
    1. approximate y_max by scanning over [a,b]
    2. simulate throwing num_needles needles in a bounding box
    3. return approximate area
    '''
    pass

# what would happen if we increase subdivisions?
# what happens when we increase num_needles?
def integrate(f, a, b, subdivisions = 5, num_needles = 1000):
    """
    Creates `subdivisions` bounding boxes each with equal width between `a` and
    `b` to calculate the area under the function f bounded by the x-axis. 
    """
    pass


def demo_integrate():
    # actual integral is 2.75
    a = -1.5
    b = 0.5
    num_trials = 10
    for subdivisions in range(1, 15):
        final_integrate = 0
        # why do we have trials here?
        for trial in range(0, num_trials):
            final_integrate += integrate(cubic, a, b, subdivisions)
        final_integrate /= num_trials
        print(f"integrating over [{a}, {b}] with {subdivisions} " \
              f"subdivisions: {final_integrate}")


demo_integrate()