import random
import numpy as np

##################################################
# Stochastic Thinking: Applications of Randomness
##################################################

# Examples of stochastic processes
# - Stochastic gradient descent
# - Modeling population dynamics (bacteria growth, spread of infectious diseases...)
# - Weather prediction
# - Gambling/chance games
# - Randomized algorithms
# - Estimation and Monte Carlo methods

##############################
# Probabilistic Overview
##############################

# 1. If you roll 2 dice, what is the likelihood of getting a sum of 10?
# 2. If you roll 2 dice, what is the probability that at least 1 dice is a 5?

################################
# Probability Code Practice
################################

# random.seed(0)
# print(random.random())
# print(random.random())

# random.seed(0)
# print(random.random())
# print(random.random())

def biased_coin_flip(p):
    """
    Simulates a biased coin flip with a given probability of heads (p).

    Args:
        p: The probability of getting heads (a float between 0 and 1).
    Returns:
        'Heads' if the coin lands heads with probability p, 'Tails' otherwise.
    """
    pass

def sample_uniform(a,b):
  '''
  Implement random.uniform(a,b)

  return a random float in the interval [a,b] where b > a over a uniform distribution
  '''
  pass

################################
# Intro Monte Carlo
################################

def simulate_dice_probability(num_trials):
    """
    Use a simulation to estimate the probability that the sum of 7 dice is divisible by either 5 or 8
    """
    pass

# print(simulate_dice_probability(100000))
# actual probability is ~ 0.32495

def estimate_e(num_samples):
    """
    Estimate the mathematical constant e using a Monte Carlo simulation.
    The expected number of uniform(0,1) random variables needed to exceed a sum of 1 is e.

    Args:
        num_samples: The number of random samples to use in the estimation.

    Returns:
        An estimate of the value of e.
    """
    pass

# print(estimate_e(100000000))
# e is approx 2.71828

##################################################
# Monte Carlo Integration
##################################################

# Sample functions to integrate over

def cubic(x):
  return x**3 - 2*x + 1

def gaussian_pdf(x):
  return (1 / (np.sqrt(2 * np.pi))) * np.exp(- (x ** 2) / (2))

# Monte Carlo Integration function 1
def integrate_monte_carlo_bbox(f, a, b, num_needles):
  '''
  Approximates the integral of f over the interval [a,b], where f(x) >=0 for all x
  1. approximate y_max by scanning over [a,b]
  2. simulate throwing num_needles needles in a bounding box
  3. return approximate area
  '''
  pass

# Monte Carlo Integration function 2
def integrate_monte_carlo_rect(f, a, b, num_samples):
  '''
  Approximates the integral of f over the interval [a,b], where f(x) >=0 for all x
  done through riemann sum approximation, where x is randomly sampled
  '''
  pass
