############################################################
# 6.101 fall 2023 midterm question 3
############################################################


def poly_add(p1, p2):
    out = zero_poly()
    new_order = max(get_order(p1), get_order(p2))
    for power in range(new_order + 1):
        set_coeff(out, power, get_coeff(p1, power) + get_coeff(p2, power))
    return out


def poly_mul(p1, p2):
    out = zero_poly()
    for ix1 in range(get_order(p1) + 1):
        new = shifted(scaled(p2, get_coeff(p1, ix1)), ix1)
        out = poly_add(out, new)
    return out


####################


def print_poly(poly):
    terms = []
    for deg in sorted(poly):
        coeff = poly[deg]
        if coeff == 0:
            continue
        if deg == 0:
            terms.append(str(coeff))
        else:
            terms.append(f"{coeff}x^{deg}")
    if len(terms) == 0:
        print("0")
    else:
        print(" + ".join(terms))


def zero_poly():
    return {0: 0}


def get_order(poly):
    non_zero_term_degrees = [deg for deg in poly if poly[deg] != 0]
    return max(non_zero_term_degrees, default=0)


def get_coeff(poly, i):
    return poly.get(i, 0)


def set_coeff(poly, i, val):
    poly[i] = val


def shifted(poly, n):
    return {deg + n: coeff for deg, coeff in poly.items()}


def scaled(poly, n):
    return {deg: coeff * n for deg, coeff in poly.items()}


print_poly(zero_poly())
p = {0:8, 1:7, 3:4}
print_poly(p)
print(get_order(p))
print(get_coeff(p, 3))
set_coeff(p, 2, 9)
print_poly(p)
p = {0:8, 1:7, 3:4}
print_poly(shifted(p, 4))
print_poly(scaled(p, 4))
print()

p1 = {1:3, 0:7}
p2 = {2:2, 1:9}
print_poly(poly_add(p1, p2))
print_poly(poly_mul(p1, p2))
print()


############################################################
# 6.101 spring 2024 final question 3
############################################################


class A:

    n = 402

    def val1(self):
        return n

    def val2(self):
        return self.n


class B(A):

    n = 401

    def __init__(self):
        self.n = n


n = 400


####################


n = 403


class C(A):
    def __init__(self):
        self.n = self.n


a = A()
print(a.val1())
print(a.val2())
print()

b = B()
print(b.val1())
print(b.val2())
print()

c = C()
print(c.val1())
print(c.val2())
print()
