import numpy as np
import sys
import time
import random

# Define the size of the square matrices
SIZE = 1000

def generate_numpy_matrix(size):
    """
    Generates a SIZE x SIZE NumPy array of random integers (0-9).
    """
    # Use NumPy's random integer generation for speed
    # dtype=np.int32 ensures we use a fixed-size integer type, similar to C++'s 'int'
    return np.random.randint(0, 10, size=(size, size), dtype=np.int32)

def multiply_matrices_numpy(matrix_a, matrix_b):
    """
    Performs matrix multiplication using NumPy's dot product operator (@).
    This operation is highly optimized and vectorized.
    """
    # The '@' operator performs matrix multiplication in NumPy (A @ B = C)
    result_matrix = matrix_a @ matrix_b
    return result_matrix

def main():
    A = generate_numpy_matrix(SIZE)
    B = generate_numpy_matrix(SIZE)
    C = multiply_matrices_numpy(A, B)
    checksum = np.sum(C)
    sys.stderr.write(f"NumPy Checksum (don't time this): {checksum}\n")


np.random.seed(int(time.time()))
main()
