import random
import time
import sys
import cProfile

# Define the size of the square matrices
SIZE = 1000

def generate_matrix():
    """Generates a SIZE x SIZE matrix (list of lists) with random integers (0-9)."""
    # Initialize the matrix with the correct dimensions
    matrix = [[0] * SIZE for _ in range(SIZE)]

    # Fill the matrix with random numbers
    for i in range(SIZE):
        for j in range(SIZE):
            # Generate a random integer between 0 and 9
            matrix[i][j] = random.randint(0, 9)
    return matrix

def multiply_matrices(matrix_a, matrix_b):
    """
    Performs standard O(n^3) matrix multiplication (A * B = C).
    """
    # Initialize the result matrix C (SIZE x SIZE) with zeros
    result_matrix = [[0] * SIZE for _ in range(SIZE)]

    # Loop for rows of the result matrix (i)
    for i in range(SIZE):
        # Loop for columns of the result matrix (j)
        for j in range(SIZE):
            # Loop for the 'dot product' (k) - columns of A and rows of B
            for k in range(SIZE):
                # Calculation: C[i][j] += A[i][k] * B[k][j]
                # This line involves two Python integer lookups, one multiplication,
                # one addition, and one assignment (which modifies the list object).
                result_matrix[i][j] += matrix_a[i][k] * matrix_b[k][j]

    return result_matrix

def main():
    A = generate_matrix()
    B = generate_matrix()
    C = multiply_matrices(A, B)

    checksum = 0
    for i in range(SIZE):
        checksum += sum(C[i])

    sys.stderr.write(f"Checksum (don't time this): {checksum}\n")

####################################
# Without profiler
####################################

random.seed(time.time())
main()

####################################
# Visual profiler example
####################################


# profiler = cProfile.Profile()
# profiler.enable()
# main()
# profiler.disable()

# # write the profile data to disk
# profiler.dump_stats("example.prof")
# print("Wrote profile to example.prof")
