#include <iostream>
#include <cstdlib>
#include <ctime>
#include <numeric>

// Define the size of the square matrices
const int SIZE = 1000;

// Function to generate and fill a matrix with random integers (0-9)
void generateMatrix(int matrix[SIZE][SIZE]) {
    static bool seeded = false;
    if (!seeded) {
        std::srand(std::time(0));
        seeded = true;
    }

    for (int i = 0; i < SIZE; ++i) {
        for (int j = 0; j < SIZE; ++j) {
            matrix[i][j] = std::rand() % 10;
        }
    }
}

// Function to multiply matrixA and matrixB and store the result in resultMatrix
void multiplyMatrices(
    const int matrixA[SIZE][SIZE],
    const int matrixB[SIZE][SIZE],
    volatile int resultMatrix[SIZE][SIZE]
) {
    for (int i = 0; i < SIZE; ++i) {
        for (int j = 0; j < SIZE; ++j) {
            resultMatrix[i][j] = 0;
            for (int k = 0; k < SIZE; ++k) {
                resultMatrix[i][j] += matrixA[i][k] * matrixB[k][j];
            }
        }
    }
}

int main() {
    // FIX: Added 'static' keyword.
    // This moves these 12MB variables off the stack and into static memory,
    // preventing the Stack Overflow segmentation fault.
    static int A[SIZE][SIZE];
    static int B[SIZE][SIZE];

    // 'volatile' is kept to prevent compiler optimization of the math
    static volatile int C[SIZE][SIZE];

    // 2. Generate random values for A and B
    generateMatrix(A);
    generateMatrix(B);

    // 3. Perform the matrix multiplication
    multiplyMatrices(A, B, C);

    long long checksum = 0;
    for (int i = 0; i < SIZE; ++i) {
        for (int j = 0; j < SIZE; ++j) {
            checksum += C[i][j];
        }
    }

    std::cerr << "Checksum (don't time this): " << checksum << std::endl;

    return 0;
}
